/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.altran.sys.OsUtil;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.commons.io.FileSystemUtils;

public class ConfigCheckPanel
extends IzPanel {
    private static final String ICON_WARNING = "check_warn";
    private static final String ICON_OK = "check_ok";
    private static final String ICON_NOT_OK = "check_ko";
    private String cpu_isalist = System.getProperty("sun.cpu.isalist");
    private String os_patch = System.getProperty("sun.os.patch.level");
    private long java_max_memory = Runtime.getRuntime().totalMemory() / 0x100000L;
    private static final long serialVersionUID = 3257848774955905587L;
    private boolean hasInvalidConfiguration = false;
    private int minHundredsMB = 1;
    private int adviceHundredsMB = 10;
    private String mainPartitionId = "C:";

    public ConfigCheckPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IzPanelLayout());
    }

    public ConfigCheckPanel(InstallerFrame parent, InstallData idata, LayoutManager2 layout) {
        super(parent, idata, layout);
        JTextArea textArea;
        if (!(layout instanceof GridBagLayout)) {
            layout = new GridBagLayout();
            this.setLayout(layout);
        }
        this.getLayoutHelper().startLayout(layout);
        this.getLayoutHelper().setDefaultConstraints(new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel tmpLabel = LabelFactory.create(parent.langpack.getString("CheckComputerConfig.Desc"), 10);
        this.add((Component)tmpLabel, this.getLayoutHelper().getNextYConstraints());
        this.add((Component)new JLabel(" "), this.getLayoutHelper().getNextYConstraints());
        ImageIcon tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
        if (this.cpu_isalist != null) {
            if (this.cpu_isalist.contains("amd64")) {
                tmpIcon = parent.icons.getImageIcon(ICON_OK);
                this.cpu_isalist = "AMD/Intel 64 bits";
            } else if (this.cpu_isalist.contains("pentium") || this.cpu_isalist.contains("i486")) {
                tmpIcon = parent.icons.getImageIcon(ICON_OK);
            } else {
                tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
                this.cpu_isalist = parent.langpack.getString("CheckComputerConfig.Unknow");
            }
        } else {
            this.cpu_isalist = parent.langpack.getString("CheckComputerConfig.Unknow");
        }
        this.addFormattedCheckLine(parent.langpack.getString("CheckComputerConfig.CPU"), this.cpu_isalist, tmpIcon);
        tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
        if (OsUtil.getOS() == null) {
            this.mainPartitionId = null;
            tmpIcon = parent.icons.getImageIcon(ICON_NOT_OK);
            this.hasInvalidConfiguration = true;
        } else {
            if (OsUtil.isLinux() || OsUtil.isMacOS()) {
                this.mainPartitionId = "/";
            } else if (OsUtil.isWindows()) {
                this.mainPartitionId = "C:";
            }
            tmpIcon = parent.icons.getImageIcon(ICON_OK);
        }
        this.addFormattedCheckLine(parent.langpack.getString("CheckComputerConfig.OS"), OsUtil.getOsName(), tmpIcon);
        if (OsUtil.getOsName().contains("Windows XP")) {
            tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
            if (this.os_patch.compareTo("Service Pack 2") == 0 || this.os_patch.compareTo("Service Pack 3") == 0) {
                tmpIcon = parent.icons.getImageIcon(ICON_OK);
            }
            this.addFormattedCheckLine(parent.langpack.getString("CheckComputerConfig.OsPatch"), this.os_patch, tmpIcon);
        } else if (OsUtil.getOsName().contains("Windows 2000")) {
            tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
            if (this.os_patch == null || this.os_patch.isEmpty() || this.os_patch.trim().compareTo("") == 0) {
                this.os_patch = parent.langpack.getString("None");
            } else if (this.os_patch.compareTo("Service Pack 3") == 0 || this.os_patch.compareTo("Service Pack 4") == 0) {
                tmpIcon = parent.icons.getImageIcon(ICON_OK);
            }
            this.addFormattedCheckLine(parent.langpack.getString("CheckComputerConfig.OsPatch"), this.os_patch, tmpIcon);
        }
        String str = parent.langpack.getString("CheckComputerConfig.SufisantMemory");
        tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
        if (this.java_max_memory >= 2L) {
            tmpIcon = parent.icons.getImageIcon(ICON_OK);
        } else if (this.java_max_memory < 1L) {
            str = parent.langpack.getString("CheckComputerConfig.NotSufisantMemory");
        }
        this.addFormattedCheckLine(parent.langpack.getString("CheckComputerConfig.Memory"), str, tmpIcon);
        try {
            long freeDiskSpace = FileSystemUtils.freeSpaceKb(this.mainPartitionId);
            String freeGB = freeDiskSpace / 0x100000L + " GB";
            tmpIcon = parent.icons.getImageIcon(ICON_WARNING);
            if (freeDiskSpace < (long)(1024 * this.minHundredsMB)) {
                this.hasInvalidConfiguration = true;
            } else if (freeDiskSpace > (long)(1024 * this.adviceHundredsMB)) {
                tmpIcon = parent.icons.getImageIcon(ICON_OK);
            }
            this.addFormattedCheckLine(parent.langpack.getString("CheckComputerConfig.FreeDiskSpace"), freeGB, tmpIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean Is64bits = Boolean.valueOf(idata.getVariable("Is64bits"));
        if (Is64bits) {
            textArea = new JTextArea(parent.langpack.getString("CheckComputerConfig.Warning64bits"));
            textArea.setFont(tmpLabel.getFont());
            textArea.setBackground(tmpLabel.getBackground());
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setForeground(Color.RED);
            this.add((Component)textArea, this.getLayoutHelper().getNextYConstraints());
        }
        if (OsUtil.isMacOS() && System.getProperty("os.version").startsWith("10.14")) {
            textArea = new JTextArea(parent.langpack.getString("CheckComputerConfig.WarningAuthorisation"));
            textArea.setFont(tmpLabel.getFont());
            textArea.setBackground(tmpLabel.getBackground());
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setForeground(Color.RED);
            this.add((Component)textArea, this.getLayoutHelper().getNextYConstraints());
        }
        this.getLayoutHelper().completeLayout();
    }

    private void addFormattedCheckLine(String checkPerformed, String result, ImageIcon icon) {
        this.addCheckLine("<html><b>" + checkPerformed + " :</b> " + result + "</html>", icon);
    }

    private void addCheckLine(String str, ImageIcon tmpIcon) {
        JLabel tmpLabel = LabelFactory.create(str, tmpIcon, 10);
        this.add((Component)tmpLabel, this.getLayoutHelper().getNextYConstraints());
        this.add((Component)new JLabel(" "), this.getLayoutHelper().getNextYConstraints());
    }

    @Override
    public boolean isValidated() {
        return !this.hasInvalidConfiguration;
    }
}

