/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.altran.sys.SystemOutLogging;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class CleanInstallListener
extends SimpleInstallerListener {
    @Override
    public void beforePacks(AutomatedInstallData automatedInstallData, Integer integer, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        super.beforePacks(automatedInstallData, integer, abstractUIProgressHandler);
        SystemOutLogging.println("beforePacks triggered");
        this.cleanInstallationFolder(automatedInstallData);
    }

    private void cleanInstallationFolder(AutomatedInstallData idata) {
        final Path installPath = Paths.get(idata.getInstallPath(), new String[0]);
        final Path logPath = installPath.resolve("log");
        final Path appPropertiesPath = installPath.resolve("app.properties");
        SystemOutLogging.println("installpath = " + installPath);
        try {
            Files.walkFileTree(installPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.equals(appPropertiesPath)) {
                        Files.delete(file);
                        SystemOutLogging.println("File deleted: " + file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.equals(logPath) && !dir.equals(installPath)) {
                        Files.delete(dir);
                        SystemOutLogging.println("Directory deleted: " + dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            SystemOutLogging.printError("Error during cleaning installation folder: " + e.getMessage());
            idata.setVariable("CleanFilesResult", "false");
        }
        idata.setVariable("CleanFilesResult", "true");
    }
}

