/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.altran.sys.OsUtil;
import com.altran.sys.SystemOutLogging;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileSystemView;

public class PostInstallPanel
extends IzPanel {
    private static final short WARN = 0;
    private static final short DONE = 1;
    private static final short FAILED = 2;
    private String pebConfigDirectoryName = "Peb";
    private final String pebConfigFileName = "user_apps.properties";
    private static final long serialVersionUID = 3257848772355905587L;
    private final JLabel resLabelUserConfig;
    private final JLabel resLabelPebRegister;
    private final JLabel resLabelCleanFiles;

    public PostInstallPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IzPanelLayout());
    }

    public PostInstallPanel(InstallerFrame parent, InstallData idata, LayoutManager2 layout) {
        super(parent, idata, layout);
        Icon tmpIcon = null;
        if (!(layout instanceof GridBagLayout)) {
            layout = new GridBagLayout();
            this.setLayout(layout);
        }
        this.getLayoutHelper().startLayout(layout);
        this.getLayoutHelper().setDefaultConstraints(new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 16, 6, 2), 0, 0));
        this.add((Component)new JLabel(" "), this.getLayoutHelper().getNextYConstraints());
        String str = parent.langpack.getString("PostInstallPanel.Results");
        JLabel labelTmp = LabelFactory.create(str, tmpIcon, 10);
        this.add((Component)labelTmp, this.getLayoutHelper().getNextYConstraints());
        this.add((Component)LabelFactory.create("    ", 10), this.getLayoutHelper().getNextYConstraints());
        this.getLayoutHelper().setDefaultConstraints(new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 30, 6, 2), 0, 0));
        this.resLabelUserConfig = LabelFactory.create("    ", tmpIcon, 10);
        this.resLabelUserConfig.setIconTextGap(15);
        this.add((Component)this.resLabelUserConfig, this.getLayoutHelper().getNextYConstraints());
        this.add((Component)LabelFactory.create("    ", 10), this.getLayoutHelper().getNextYConstraints());
        this.resLabelCleanFiles = LabelFactory.create("    ", tmpIcon, 10);
        this.resLabelCleanFiles.setIconTextGap(15);
        this.add((Component)this.resLabelCleanFiles, this.getLayoutHelper().getNextYConstraints());
        this.add((Component)LabelFactory.create("    ", 10), this.getLayoutHelper().getNextYConstraints());
        this.resLabelPebRegister = LabelFactory.create("    ", tmpIcon, 10);
        this.resLabelPebRegister.setIconTextGap(15);
        this.add((Component)this.resLabelPebRegister, this.getLayoutHelper().getNextYConstraints());
        this.resLabelPebRegister.setVisible(false);
        this.getLayoutHelper().completeLayout();
    }

    private short createDefUserPref() {
        short ret = 2;
        try {
            String configDest = System.getProperty("user.home");
            if (OsUtil.isWindows()) {
                configDest = System.getenv("APPDATA");
            } else if (OsUtil.isLinux() || OsUtil.isMacOS()) {
                this.pebConfigDirectoryName = ".peb";
            }
            File file = new File(configDest + File.separator + this.pebConfigDirectoryName + File.separator + "user_apps.properties");
            Debug.log("Peb Config File=" + file);
            boolean fileWasExisting = file.exists();
            if (!fileWasExisting) {
                file.getParentFile().mkdirs();
            }
            if (OsUtil.isLinux() || OsUtil.isMacOS()) {
                PostInstallPanel.chmod(file, "a+rwx");
            }
            if (fileWasExisting) {
                return 0;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            String lang = this.idata.getVariable("ISO3_LANG");
            String lg = this.getISO2LangId(lang);
            bw.write("# installation language = " + lang);
            bw.newLine();
            bw.write("user.lang=");
            Debug.log("Peb language ID=" + lg);
            bw.write(lg);
            bw.newLine();
            this.setDefProjetsFolder(bw);
            bw.close();
            ret = 1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void updateLabelUserConfig(int res) {
        String str;
        ImageIcon tmpIcon;
        if (res == 0) {
            tmpIcon = this.parent.icons.getImageIcon("check_ok");
            str = this.parent.langpack.getString("PostInstallPanel.UserPrefFileAlredayExist");
        } else if (res == 1) {
            tmpIcon = this.parent.icons.getImageIcon("check_ok");
            str = this.parent.langpack.getString("PostInstallPanel.UserPrefFileCreated");
        } else {
            tmpIcon = this.parent.icons.getImageIcon("check_ko");
            str = this.parent.langpack.getString("PostInstallPanel.UserPrefFileFailed");
        }
        this.resLabelUserConfig.setText(str);
        this.resLabelUserConfig.setIcon(tmpIcon);
    }

    private void setDefProjetsFolder(BufferedWriter bw) {
        JFileChooser fr = new JFileChooser();
        fr.setFileHidingEnabled(true);
        FileSystemView fw = fr.getFileSystemView();
        String homePath = fw.getDefaultDirectory().getPath();
        Debug.log("User's My Documents Path=" + homePath);
        File f = new File(homePath);
        if (f.exists()) {
            f = new File(homePath + File.separator + this.parent.langpack.getString("PostInstallPanel.MyPEBProject"));
            f.mkdir();
            if (OsUtil.isLinux() || OsUtil.isMacOS()) {
                PostInstallPanel.chmod(f, "a+rwx");
            }
            try {
                bw.write("# default Projects Directory");
                bw.newLine();
                bw.write("save.defaultProjectsDir=");
                String str = f.getPath().replaceAll("\\\\", "\\\\\\\\");
                bw.write(str);
                bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getISO2LangId(String lang) {
        Debug.log("ISO2 Language code=" + lang);
        if (lang.startsWith("fra") || lang.startsWith("fre")) {
            return "fr";
        }
        if (lang.startsWith("eng")) {
            return "en";
        }
        if (lang.startsWith("ned") || lang.startsWith("dut") || lang.startsWith("nla")) {
            return "nl";
        }
        if (lang.startsWith("deu") || lang.startsWith("ger")) {
            return "de";
        }
        return "fr";
    }

    @Override
    public String getSummaryBody() {
        return "Action to finalize the instalation of the PEB software";
    }

    private void removeApplicationFromRegistry(String install_path) {
        if (OsUtil.isWindows()) {
            Debug.log("Remove Application From Registry");
            try {
                File f = File.createTempFile("peb_install_clean_reg", ".reg");
                PostInstallPanel.createCleanRegFile(f);
                this.execRegistryBatch(f);
                Debug.log(" \tDone");
            }
            catch (Exception e) {
                SystemOutLogging.printError(" \tError:");
                e.printStackTrace();
            }
        }
    }

    private boolean registerApplicationToRegistry(String install_path) {
        if (OsUtil.isWindows()) {
            try {
                File f = File.createTempFile("peb_install_add_reg", ".reg");
                String PEB_file_title = this.parent.langpack.getString("PostInstallPanel.PEBFileTitle");
                String PEB_open_title = this.parent.langpack.getString("PostInstallPanel.OpenPEBFileTitle");
                PostInstallPanel.createAddRegFile(f, install_path, PEB_file_title, PEB_open_title);
                this.execRegistryBatch(f);
                Debug.log(" \tDone");
                return true;
            }
            catch (Exception e) {
                SystemOutLogging.printError(" \tError: ");
                e.printStackTrace();
            }
        }
        return false;
    }

    private void execRegistryBatch(File f) throws IOException, InterruptedException {
        Process proc = Runtime.getRuntime().exec("regedit /S " + f.getPath());
        proc.waitFor();
        proc.destroy();
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.doChecks();
    }

    private void doChecks() {
        short defUserPref = this.createDefUserPref();
        this.updateLabelUserConfig(defUserPref);
        String installPath = this.idata.getInstallPath();
        if (OsUtil.isWindows()) {
            this.removeApplicationFromRegistry(installPath);
            Debug.log("Installation Path=" + installPath);
            boolean applicationToRegistry = this.registerApplicationToRegistry(installPath);
            this.updateLabelPebRegister(applicationToRegistry);
        } else if (OsUtil.isLinux() || OsUtil.isMacOS()) {
            String path = installPath;
            String JREPath = PostInstallPanel.getJREVersion(new File(path));
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            PostInstallPanel.chmod(new File(path + "database"), "a+rwx");
            PostInstallPanel.chmod(new File(path + "examples"), "a+rwx");
            PostInstallPanel.chmod(new File(path + "log"), "a+rwx");
            PostInstallPanel.chmod(new File(path + JREPath), "a+rwx");
            PostInstallPanel.chmod(new File(path), "a+rwx");
        }
        this.updateLabelCleanFiles(Boolean.parseBoolean(this.idata.getVariable("CleanFilesResult")));
    }

    private void updateLabelCleanFiles(boolean cleanFilesResult) {
        if (cleanFilesResult) {
            this.resLabelCleanFiles.setText(this.parent.langpack.getString("PostInstallPanel.CleanFilesOk"));
            this.resLabelCleanFiles.setIcon(this.parent.icons.getImageIcon("check_ok"));
        } else {
            this.resLabelCleanFiles.setText(this.parent.langpack.getString("PostInstallPanel.CleanFilesKo"));
            this.resLabelCleanFiles.setIcon(this.parent.icons.getImageIcon("check_ko"));
        }
    }

    private void updateLabelPebRegister(boolean applicationToRegistry) {
        if (applicationToRegistry) {
            this.resLabelPebRegister.setText(this.parent.langpack.getString("PostInstallPanel.PEBOpenWithOk"));
            this.resLabelPebRegister.setIcon(this.parent.icons.getImageIcon("check_ok"));
        } else {
            this.resLabelPebRegister.setText(this.parent.langpack.getString("PostInstallPanel.PEBOpenWithKo"));
            this.resLabelPebRegister.setIcon(this.parent.icons.getImageIcon("check_ko"));
        }
        this.resLabelPebRegister.setVisible(OsUtil.isWindows());
    }

    private static boolean chmod(File f, String pattern) {
        try {
            if (f.isDirectory()) {
                String[] cmd = new String[]{"chmod", "-R", pattern, f.getPath()};
                Process proc = Runtime.getRuntime().exec(cmd);
                int exival = proc.waitFor();
                proc.destroy();
                if (exival != 0) {
                    SystemOutLogging.printError(String.format("chmod failed : %s %s %s %s%n -> Exit value : %d", cmd[0], cmd[1], cmd[2], cmd[3], exival));
                    return false;
                }
                return true;
            }
            String[] cmd = new String[]{"chmod", pattern, f.getPath()};
            Process proc = Runtime.getRuntime().exec(cmd);
            int exival = proc.waitFor();
            proc.destroy();
            if (exival != 0) {
                SystemOutLogging.printError(String.format("chmod failed : %s %s %s%n -> Exit value : %d", cmd[0], cmd[1], cmd[2], exival));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String getJREVersion(File f) {
        if (f.isDirectory()) {
            String[] list;
            for (String pathname : list = f.list()) {
                if (!pathname.contains("jre")) continue;
                return pathname;
            }
        }
        return "";
    }

    private static void createCleanRegFile(File f) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        bw.write("Windows Registry Editor Version 5.00");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\shell\\Ouvrir_avec\\command]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\shell\\Ouvrir_avec]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\DefaultIcon]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\shell]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\.peb]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_CLASSES_ROOT\\pebapp\\shell\\Ouvrir_avec\\command]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_CLASSES_ROOT\\pebapp\\shell\\Ouvrir_avec]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_CLASSES_ROOT\\pebapp\\shell]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_CLASSES_ROOT\\pebapp\\DefaultIcon]");
        bw.newLine();
        bw.newLine();
        bw.write("[-HKEY_CLASSES_ROOT\\pebapp]");
        bw.newLine();
        bw.close();
    }

    private static void createAddRegFile(File f, String install_path, String PEB_file_title, String PEB_open_title) throws IOException {
        String PEB_install_path = install_path.replaceAll("\\\\", "\\\\\\\\");
        String execCmd = "@=\"\\\"C:\\\\WINDOWS\\\\system32\\\\cscript.exe\\\" //nologo \\\"" + PEB_install_path + "\\\\PEBOpenWith.vbs\\\" \\\"-o\\\" \\\"%1\\\"\"\n";
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        bw.write("Windows Registry Editor Version 5.00");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_CLASSES_ROOT\\pebapp]");
        bw.newLine();
        bw.write("\"EditFlags\"=dword:00000000");
        bw.newLine();
        bw.write("\"BrowserFlags\"=dword:00000008");
        bw.newLine();
        bw.write("@=\"" + PEB_file_title + "\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_CLASSES_ROOT\\pebapp\\DefaultIcon]");
        bw.newLine();
        bw.write("@=\"" + PEB_install_path + "\\peb.ico,0\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_CLASSES_ROOT\\pebapp\\shell]");
        bw.newLine();
        bw.write("@=\"Ouvrir_avec\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_CLASSES_ROOT\\pebapp\\shell\\Ouvrir_avec]");
        bw.newLine();
        bw.write("@=\"" + PEB_open_title + "\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_CLASSES_ROOT\\pebapp\\shell\\Ouvrir_avec\\command]");
        bw.write(execCmd);
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\.peb]");
        bw.newLine();
        bw.write("@=\"pebapp\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp]");
        bw.newLine();
        bw.write("\"EditFlags\"=dword:00000000");
        bw.newLine();
        bw.write("\"BrowserFlags\"=dword:00000008");
        bw.newLine();
        bw.write("@=\"" + PEB_file_title + "\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\DefaultIcon]");
        bw.newLine();
        bw.write("@=\"" + PEB_install_path + "\\\\peb.ico,0\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\shell]");
        bw.newLine();
        bw.write("@=\"Ouvrir_avec\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\shell\\Ouvrir_avec]");
        bw.newLine();
        bw.write("@=\"" + PEB_open_title + "\"");
        bw.newLine();
        bw.newLine();
        bw.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Classes\\pebapp\\shell\\Ouvrir_avec\\command]");
        bw.newLine();
        bw.write(execCmd);
        bw.newLine();
        bw.close();
    }
}

