/*
 * Decompiled with CFR 0.152.
 */
package com.altran.sys;

public class OsUtil {
    private static OS os = null;

    public static OS getOS() {
        if (os != null) {
            return os;
        }
        String osName = OsUtil.getOsName();
        if (osName.toLowerCase().startsWith("mac os")) {
            os = OS.MAC_OS;
        } else if (osName.toLowerCase().startsWith("windows")) {
            os = OS.WINDOWS;
        } else if (osName.toLowerCase().startsWith("linux")) {
            os = OS.LINUX;
        }
        return os;
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static boolean isMacOS() {
        return OS.MAC_OS.equals((Object)OsUtil.getOS());
    }

    public static boolean isLinux() {
        return OS.LINUX.equals((Object)OsUtil.getOS());
    }

    public static boolean isWindows() {
        return OS.WINDOWS.equals((Object)OsUtil.getOS());
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC_OS;

    }
}

