/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class InstallPanel
extends IzPanel
implements AbstractUIProgressHandler {
    private static final long serialVersionUID = 3257282547959410992L;
    protected JLabel tipLabel;
    protected JLabel packOpLabel;
    protected JLabel overallOpLabel;
    protected String iconName = "preferences";
    protected JProgressBar packProgressBar;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;

    public InstallPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        this.tipLabel = LabelFactory.create(installerFrame.langpack.getString("InstallPanel.tip"), installerFrame.icons.getImageIcon(this.iconName), 10);
        this.add((Component)this.tipLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packOpLabel = LabelFactory.create(" ", 10);
        this.add((Component)this.packOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(installerFrame.langpack.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        this.add((Component)this.packProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.add(IzPanelLayout.createVerticalStrut(5));
        this.overallOpLabel = LabelFactory.create(installerFrame.langpack.getString("InstallPanel.progress"), installerFrame.icons.getImageIcon(this.iconName), 10);
        this.add((Component)this.overallOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        if (this.noOfPacks == 1) {
            this.overallProgressBar.setIndeterminate(true);
        }
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        this.add((Component)this.overallProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.getLayoutHelper().completeLayout();
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startAction(String string, int n) {
        this.noOfPacks = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.parent.blockGUI();
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setMaximum(InstallPanel.this.noOfPacks);
                InstallPanel.this.overallProgressBar.setString("0 / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    public void emitError(String string, String string2) {
        this.packOpLabel.setText(string2);
        this.idata.installSuccess = false;
        JOptionPane.showMessageDialog(this, string2, this.parent.langpack.getString("installer.error"), 0);
    }

    public void stopAction() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.parent.releaseGUI();
                InstallPanel.this.parent.lockPrevButton();
                InstallPanel.this.overallProgressBar.setValue(InstallPanel.this.overallProgressBar.getMaximum());
                int n = InstallPanel.this.packProgressBar.getMaximum();
                if (n < 1) {
                    n = 1;
                    InstallPanel.this.packProgressBar.setMaximum(n);
                }
                InstallPanel.this.packProgressBar.setValue(n);
                InstallPanel.this.packProgressBar.setString(((InstallPanel)InstallPanel.this).parent.langpack.getString("InstallPanel.finished"));
                InstallPanel.this.packProgressBar.setEnabled(false);
                String string = Integer.toString(InstallPanel.this.noOfPacks);
                if (InstallPanel.this.noOfPacks == 1) {
                    InstallPanel.this.overallProgressBar.setIndeterminate(false);
                }
                InstallPanel.this.overallProgressBar.setString(string + " / " + string);
                InstallPanel.this.overallProgressBar.setEnabled(false);
                InstallPanel.this.packOpLabel.setText(" ");
                InstallPanel.this.packOpLabel.setEnabled(false);
                ((InstallPanel)InstallPanel.this).idata.canClose = true;
                InstallPanel.this.validated = true;
                if (((InstallPanel)InstallPanel.this).idata.panels.indexOf(this) != ((InstallPanel)InstallPanel.this).idata.panels.size() - 1) {
                    InstallPanel.this.parent.unlockNextButton();
                }
            }
        });
    }

    public void progress(final int n, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packProgressBar.setValue(n + 1);
                InstallPanel.this.packOpLabel.setText(string);
            }
        });
    }

    public void nextStep(final String string, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packProgressBar.setValue(0);
                InstallPanel.this.packProgressBar.setMinimum(0);
                InstallPanel.this.packProgressBar.setMaximum(n2);
                InstallPanel.this.packProgressBar.setString(string);
                InstallPanel.this.overallProgressBar.setValue(n - 1);
                InstallPanel.this.overallProgressBar.setString(Integer.toString(n) + " / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    public void setSubStepNo(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallPanel.this.packProgressBar.setMaximum(n);
            }
        });
    }

    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        this.parent.install(this);
    }
}

